package gov.va.vamf.scheduling.varutility.datalayer;

import gov.va.vamf.scheduling.varutility.domain.Institution;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import gov.va.vamf.scheduling.varutility.utils.DAOConstants;

public class InstitutionResultSetRowMapper implements RowMapper<Institution> {

    @Override
    public Institution mapRow(ResultSet rs, int rowNum) throws SQLException {

        Institution institution = new Institution();

        String institutionName = StringUtils.trimToEmpty(rs.getString(DAOConstants.INSTITUTION_NAME_COL));
        institution.setDivisionName(institutionName);

        String station = StringUtils.trimToEmpty(rs.getString(DAOConstants.STATION_COL));
        institution.setParentName(station);

        String institutionCode = StringUtils.trimToEmpty(rs.getString(DAOConstants.INSTITUTION_CODE_COL));
        institution.setChildName(institutionCode);

        return (institution);
    }

}
